<?php
/**
 * @author QuanticaLabs - http://codecanyon.net/user/QuanticaLabs/portfolio?ref=QuanticaLabs
 *
 * @link			http://codecanyon.net/item/timetable-responsive-schedule-for-joomla/9749539?ref=QuanticaLabs
 * @copyright		Copyright (C) 2008 - 2014 quanticalabs.com . All rights reserved.
 * @license			GNU General Public License version 2 or later; see LICENSE under Licensing/ directory
 */
 
defined('_JEXEC') or die('Restricted access');

JLoader::register('TimetableHelper', JPATH_ADMINISTRATOR . '/components/com_timetable/helpers/timetable.php');

class TimetableModelEvent_Option extends JModelAdmin
{
	
	public $typeAlias = 'com_timetable.event_option';
	protected $text_prefix = 'COM_TIMETABLE';
	
	
	public function getTable($type = 'Event_Options', $prefix = 'TimetableTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	public function getForm($data = array(), $loadData = true)
	{
		// Get the form.
		$form = $this->loadForm('com_timetable.event_option', 'event_option',
			array('control' => 'jform', 'load_data' => $loadData));
		if (empty($form))
		{
			return false;
		}

		return $form;
	}

	protected function loadFormData()
	{
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState('com_timetable.edit.event_option.data', array());
		if (empty($data))
		{
			$data = $this->getItem();
		}

		return $data;
	}
	
}